﻿using System;
using System.IO;
using Xamarin.Forms;

namespace XamarinFormsExample
{
    public partial class MainPage : ContentPage
    {
        private Stream? _fileStream;
        private int _counter = 0;

        public MainPage()
        {
            InitializeComponent();
        }

        private void OnOpenFileClicked(object? sender, EventArgs e)
        {
            var path = Path.GetFullPath(".");
            _fileStream = File.OpenRead(Path.Combine(path, "data.bin"));
        }

        private void OnCloseFileClicked(object? sender, EventArgs e)
        {
            _fileStream?.Dispose();
            _fileStream = null;
        }

        private void OnReadByteClicked(object? sender, EventArgs e)
        {
            if (_fileStream != null)
            {
                _ = _fileStream.ReadByte();
                _counter++;
                BytesCounter.Text = $"Bytes read: {_counter}";
            }
        }
    }
}