package com.example.demo

import org.springframework.boot.test.context.SpringBootTest
import org.springframework.test.context.DynamicPropertyRegistry
import org.springframework.test.context.DynamicPropertySource
import org.testcontainers.containers.GenericContainer
import org.testcontainers.containers.wait.strategy.HostPortWaitStrategy
import org.testcontainers.spock.Testcontainers
import spock.lang.Specification

@Testcontainers
@SpringBootTest
abstract class TestcontainersIntegrationsTest extends Specification {

    public static final String REDIS_IMAGE = "public.ecr.aws/docker/library/redis:8-alpine"
    public static final int REDIS_PORT = 6379

    public static GenericContainer redis = new GenericContainer<>(REDIS_IMAGE)
            .withExposedPorts(REDIS_PORT)
            .withCommand("redis-server --loglevel warning").waitingFor(new HostPortWaitStrategy())

    static {
        redis.start()
    }

    @DynamicPropertySource
    static void redisProps(DynamicPropertyRegistry registry) {
        registry.add("spring.data.redis.host", redis::getHost)
        registry.add("spring.data.redis.port", () -> redis.getMappedPort(6379))
    }
}