package com.example.demo

import org.springframework.beans.factory.annotation.Autowired
import org.springframework.data.redis.connection.RedisConnection
import org.springframework.data.redis.connection.RedisConnectionFactory

import static java.nio.charset.StandardCharsets.UTF_8

class RedisIntegrationsTest extends TestcontainersIntegrationsTest {

    public static final byte[] ROOT = '.'.getBytes(UTF_8)

    @Autowired
    RedisConfig redisConfig

    @Autowired
    RedisConnectionFactory connectionFactory

    RedisConnection connection

    private static byte[] bytes(String string) {
        string.getBytes(UTF_8)
    }

    void setup() {
        connection = connectionFactory.connection
        connection.execute('JSON.SET', bytes('key1'), ROOT, bytes('"value1"'))
        connection.execute('JSON.SET', bytes('key2'), ROOT, bytes('"value2"'))
        connection.execute('JSON.SET', bytes('key3'), ROOT, bytes('"value3"'))
    }

    def 'should return more than the last key'() {
        when:
        var raw = connection.execute('JSON.MGET', bytes('key1'), bytes('key2'), bytes('key3'), ROOT)
        def decoded = new String(raw)

        then:
        decoded != '"value3"'
    }
}
