package com.example.demo;

import lombok.AllArgsConstructor;
import org.springframework.boot.autoconfigure.data.redis.RedisProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.RedisStandaloneConfiguration;
import org.springframework.data.redis.connection.lettuce.LettuceClientConfiguration;
import org.springframework.data.redis.connection.lettuce.LettuceConnectionFactory;

import java.time.Duration;

@Configuration
@AllArgsConstructor
public class RedisConfig {

    private final RedisProperties properties;

    @Bean
    public RedisConnectionFactory getRedisConnectionFactory() {
        var redisConfig = new RedisStandaloneConfiguration(properties.getHost(), properties.getPort());
        redisConfig.setDatabase(0);
        redisConfig.setUsername(properties.getUsername());
        redisConfig.setPassword(properties.getPassword());

        var lettuceClientConfig =
            LettuceClientConfiguration.builder()
                .commandTimeout(Duration.ofMillis(500))
                .shutdownTimeout(Duration.ofMillis(100));

        return new LettuceConnectionFactory(redisConfig, lettuceClientConfig.build());
    }
}
