package com.example.demo;

import org.junit.jupiter.api.Test;
import org.springframework.batch.core.BatchStatus;
import org.springframework.batch.core.configuration.annotation.EnableBatchProcessing;
import org.springframework.batch.core.job.JobExecution;
import org.springframework.batch.core.step.StepExecution;
import org.springframework.batch.test.JobOperatorTestUtils;
import org.springframework.batch.test.context.SpringBatchTest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.junit.jupiter.SpringJUnitConfig;

import java.util.Collection;

import static org.junit.jupiter.api.Assertions.assertEquals;

@SpringBatchTest
@EnableBatchProcessing
@SpringJUnitConfig(JobConfig.class)
class DemoApplicationTests {

    @Autowired
    private JobOperatorTestUtils jobOperatorTestUtils;

    @Test
    void countItems() throws Exception {
        JobExecution jobExecution = jobOperatorTestUtils.startJob();
        assertEquals(BatchStatus.COMPLETED, jobExecution.getStatus());

        Collection<StepExecution> stepExecutions = jobExecution.getStepExecutions();
        assertEquals(4, stepExecutions.size());

        StepExecution stepExecution = stepExecutions.iterator().next();
        assertEquals(60, stepExecution.getWriteCount());
    }

}
