// server.js - Node.js 22 Version
import express from 'express';

const app = express();
const port = process.env.PORT || 3000;

app.use(express.json());

app.get('/api/healthz', (req, res) => {
  res.status(200).send('ok');
});

app.use((err, req, res, next) => {
  console.error('Error:', err);
  res.status(500).send('Internal Server Error');
});

const server = app.listen(port, () => {
  console.log(`Node.js 22 server running on port ${port}`);
  console.log(`Node version: ${process.version}`);
});

const shutdown = () => {
  console.log('Shutdown signal received, closing server gracefully');
  server.close(() => {
    console.log('Server closed');
    process.exit(0);
  });
};

process.on('SIGTERM', () => shutdown());
process.on('SIGINT', () => shutdown());