package com.example;

import io.micronaut.http.*;
import io.micronaut.http.annotation.Controller;
import io.micronaut.http.annotation.Get;
import io.micronaut.http.client.HttpClient;
import io.micronaut.http.client.annotation.Client;
import io.micronaut.http.uri.UriBuilder;
import io.micronaut.runtime.http.scope.RequestScope;
import io.micronaut.scheduling.TaskExecutors;
import io.micronaut.scheduling.annotation.ExecuteOn;
import jakarta.inject.Inject;
import reactor.core.publisher.Mono;

import java.net.URI;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;

@Controller("/test")
@RequestScope
public class TestResource {

    @Inject
    HttpClient httpClient;

    final String baseUri = "http://localhost:9000/health";


    @Get(uri = "/http", produces = MediaType.TEXT_PLAIN)
    public HttpResponse<?> testHttpClient() {
        URI builder = UriBuilder.of(baseUri).build();

        HttpRequest<?> request = HttpRequest.GET(baseUri)
                .accept(MediaType.APPLICATION_JSON_TYPE)
                .contentType(MediaType.APPLICATION_JSON_TYPE)
                .uri(builder);

        HttpResponse<String> response = httpClient.toBlocking().exchange(request, String.class);
        String resBody = response.getBody().isPresent() ? response.getBody().get() : null;
        HttpStatus status = response.status();

        System.out.println("Response status= " + status);
        return HttpResponse.ok();
    }

    @Get(uri = "/http3", produces = MediaType.TEXT_PLAIN)
    public Mono<MutableHttpResponse<String>> testHttpClient3() {

        URI builder = UriBuilder.of(baseUri).build();

        HttpRequest<?> request = HttpRequest.GET(baseUri)
                .accept(MediaType.APPLICATION_JSON_TYPE)
                .contentType(MediaType.APPLICATION_JSON_TYPE)
                .uri(builder);

        return Mono.from(httpClient.retrieve(request, String.class))
                .map(resp -> {
                    String processedResponse = "health result "+resp;
                    return HttpResponse.ok(processedResponse);
                }).onErrorResume(e -> {
                    String errorMessage = "Error occurred: " + e.getMessage();
                    System.err.println(errorMessage);
                    e.printStackTrace();
                    return Mono.just(HttpResponse.serverError(errorMessage));
                });
    }

}
