declare module "internals" {
    export const block: symbol;
    export const repeatCtx: symbol;
    export function requestIdleCallback(cb: any, ...args: any[]): NodeJS.Timeout;
    export const internals: symbol;
    export const CREATE: symbol;
    export const RENDER: symbol;
    export const ADDED: symbol;
    export const REMOVED: symbol;
    export const debug: symbol;
    export const index: symbol;
}
declare module "utils" {
    export function forceUpdate(target: typeof import("component"), ...keys: string[]): void;
    export { requestIdleCallback };
    export function findCtx(t: Node | Element | null): any;
    export function isForcedUpdate(t: any): boolean;
    export function markFlush(t: any, flush: any): WeakMap<object, any>;
    export function dashToCamel(dash: string): string;
    export function lazyQueue(queue: Set<Function> | Array<Function>, timeout?: number | undefined, onComplete?: Function | undefined): void;
    export function normalize(html: string): string;
    export function memoize(fn: Function): (str: any) => any;
    export function createFunction(...args: string[]): any;
    export function NOOP(): undefined;
    import { requestIdleCallback } from "internals";
}
declare module "expression" {
    export const parse: (expression: string) => ParseResult;
    export type ParseResult = {
        paths: string[];
        expressions: string[];
    };
}
declare module "typedefs" {
    export type NodeProcessInfo = {
        scopeNode: any | Element;
        targetNode: Element;
        targetNodeName: string;
        attribute: Attr;
        attributeName: string;
        attributeValue: string | null;
        expression: string;
        context: any;
        props: string[];
    };
    export type NodeProcessResult = {
        update?: ((value: any, forceUpdate: boolean) => any) | undefined;
        removeAttribute?: boolean | undefined;
        removeNode?: boolean | undefined;
        noInvocation?: boolean | undefined;
    };
    export type AttributeTest = (attr: Attr, nodeName: string, nodeValue: string) => any;
    export type NodeProcessor = (info: NodeProcessInfo) => NodeProcessResult;
    export type Plugin = (phase: symbol, target: import('./index.js').Slim) => any;
    export type Directive = {
        attribute: AttributeTest;
        process: NodeProcessor;
        noExecution?: boolean | undefined;
    };
}
declare module "enhance" {
    export const DirectiveRegistry: Registry<Directive>;
    export const PluginRegistry: PluginRegistryClass;
    export type Plugin = (import("typedefs").Plugin);
    export type Directive = import("typedefs").Directive;
    class Registry<T> {
        add(addon: T, priority?: boolean): void;
        getAll(): T[];
        [addons]: T[];
    }
    class PluginRegistryClass extends Registry<import("typedefs").Plugin> {
        constructor();
        exec(phase: symbol, target: import("./index.js").Slim): void;
    }
    const addons: unique symbol;
    export {};
}
declare module "dom" {
    export function createBind(source: any, target: any, property: any, execution: any): () => void;
    export function runBinding(source: any, property: any, value: any): void;
    export function removeBindings(source: any, target: any, property?: string): void;
    export function processDOM(scope: any, dom: Node): {
        flush: (...props: string[]) => void;
        clear: () => void;
        bounds: Set<Function>;
    };
}
declare module "component" {
    export default class Component extends HTMLElement {
        static template: string;
        static useShadow: boolean;
        static element(tag: string, template: string, base?: typeof Component | undefined): void;
        onBeforeCreated(): void;
        onCreated(): void;
        onAdded(): void;
        onRemoved(): void;
        onRender(): void;
        protected connectedCallback(): void;
        disconnectedCallback(): void;
    }
}
declare module "index" {
    export * as Utils from "utils";
    export namespace Phase {
        export { ADDED };
        export { CREATE };
        export { RENDER };
        export { REMOVED };
    }
    export namespace Internals {
        export { repeatCtx };
        export { internals };
        export { block };
        export { index };
        export { requestIdleCallback };
    }
    import Component from "component";
    import { ADDED } from "internals";
    import { CREATE } from "internals";
    import { RENDER } from "internals";
    import { REMOVED } from "internals";
    import { repeatCtx } from "internals";
    import { internals } from "internals";
    import { block } from "internals";
    import { index } from "internals";
    import { requestIdleCallback } from "internals";
    export { Component as Slim, Component };
    export { DirectiveRegistry, PluginRegistry } from "./enhance.js";
    export { processDOM, removeBindings, createBind } from "./dom.js";
}
