declare type DirectiveRegister = (directive: Directive) => void;
interface DirectiveOptions<T = any> {
    targetNode: Element | HTMLElement;
    componentNode: Element | HTMLElement;
    attribute: Attr;
    expression: string | null;
    paths: string[];
}
export interface Directive<T = any> {
    attribute: string | ((attr: Attr) => any);
    process: (options: DirectiveOptions<T>) => (Function & {
        sideEffect?: boolean;
    }) | void;
    registerAsGlobal?: (register: DirectiveRegister | undefined) => void;
}
declare class DirectiveRegistry {
    private directives;
    register(directive: Directive): void;
    getDirectives(): Directive[];
}
export declare const Registry: DirectiveRegistry;
export {};
//# sourceMappingURL=directive.d.ts.map