(function webpackUniversalModuleDefinition(root, factory) {
	if(typeof exports === 'object' && typeof module === 'object')
		module.exports = factory(require("mimbl"));
	else if(typeof define === 'function' && define.amd)
		define(["mimbl"], factory);
	else {
		var a = typeof exports === 'object' ? factory(require("mimbl")) : factory(root["mimbl"]);
		for(var i in a) (typeof exports === 'object' ? exports : root)[i] = a[i];
	}
})(this, function(__WEBPACK_EXTERNAL_MODULE_mimbl__) {
return /******/ (() => { // webpackBootstrap
/******/ 	"use strict";
/******/ 	var __webpack_modules__ = ({

/***/ "./src/Main.tsx":
/*!**********************!*\
  !*** ./src/Main.tsx ***!
  \**********************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
const mim = __webpack_require__(/*! mimbl */ "mimbl");
let adjectives = ["pretty", "large", "big", "small", "tall", "short", "long", "handsome", "plain", "quaint", "clean", "elegant", "easy", "angry", "crazy", "helpful", "mushy", "odd", "unsightly", "adorable", "important", "inexpensive", "cheap", "expensive", "fancy"];
let colours = ["red", "yellow", "blue", "green", "pink", "brown", "purple", "brown", "white", "black", "orange"];
let nouns = ["table", "chair", "house", "bbq", "desk", "car", "pony", "cookie", "sandwich", "burger", "pizza", "mouse", "keyboard"];
let nextID = 1;
function buildRows(/*main: Main,*/ count) {
    let rows = new Array(count);
    let label, id;
    for (let i = 0; i < count; i++) {
        id = nextID++;
        label = `${adjectives[rand(adjectives.length)]} ${colours[rand(colours.length)]} ${nouns[rand(nouns.length)]}`;
        rows[i] = {
            id,
            idTrigger: mim.createTrigger(id),
            label,
            labelTrigger: mim.createTrigger(label),
            selectedTrigger: mim.createTrigger()
        };
    }
    return rows;
}
function rand(max) {
    return Math.round(Math.random() * 1000) % max;
}
function Button(props, children) {
    return mim.jsx("div", { class: "col-sm-6 smallpad" },
        mim.jsx("button", Object.assign({ type: "button", class: "btn btn-primary btn-block" }, props), children));
}
class Main extends mim.Component {
    constructor() {
        super(...arguments);
        this.rows = null;
        // private rows: Row[] = null;
        this.selectedRow = undefined;
        this.onSelectRowClicked = (e, rowToSelect) => {
            if (rowToSelect === this.selectedRow)
                return;
            if (this.selectedRow)
                this.selectedRow.selectedTrigger.set(null);
            this.selectedRow = rowToSelect;
            rowToSelect.selectedTrigger.set("danger");
        };
        this.onDeleteRowClicked = (e, rowToDelete) => {
            if (rowToDelete === this.selectedRow)
                this.selectedRow = undefined;
            let i = this.rows.indexOf(rowToDelete);
            this.rows.splice(i, 1);
            this.vnTBody.spliceChildren(i, 1, undefined, 1 /* Sync */);
        };
    }
    render() {
        return (mim.jsx("div", { class: "container" },
            mim.jsx("div", { class: "jumbotron" },
                mim.jsx("div", { class: "row" },
                    mim.jsx("div", { class: "col-md-6" },
                        mim.jsx("h1", null, "Mimbl (non-keyed)")),
                    mim.jsx("div", { class: "col-md-6" },
                        mim.jsx("div", { class: "row" },
                            mim.jsx(Button, { id: "run", click: this.onCreate1000 }, "Create 1,000 rows"),
                            mim.jsx(Button, { id: "runlots", click: this.onCreate10000 }, "Create 10,000 rows"),
                            mim.jsx(Button, { id: "add", click: this.onAppend1000 }, "Append 1,000 rows"),
                            mim.jsx(Button, { id: "update", click: this.onUpdateEvery10th }, "Update every 10th row"),
                            mim.jsx(Button, { id: "clear", click: this.onClear }, "Clear"),
                            mim.jsx(Button, { id: "swaprows", click: this.onSwapRows }, "Swap Rows"))))),
            mim.jsx("table", { class: "table table-hover table-striped test-data" }, this.renderRows),
            mim.jsx("span", { class: "preloadicon glyphicon glyphicon-remove", "aria-hidden": "true" })));
    }
    renderRows() {
        var _a;
        return mim.jsx("tbody", { vnref: this.vnTBody }, (_a = this.rows) === null || _a === void 0 ? void 0 : _a.map(row => mim.jsx("tr", { class: row.selectedTrigger },
            mim.jsx("td", { class: "col-md-1" }, row.idTrigger),
            mim.jsx("td", { class: "col-md-4" },
                mim.jsx("a", { click: [this.onSelectRowClicked, row] }, row.labelTrigger)),
            mim.jsx("td", { class: "col-md-1" },
                mim.jsx("a", { click: [this.onDeleteRowClicked, row] },
                    mim.jsx("span", { class: "glyphicon glyphicon-remove", "aria-hidden": "true" }))),
            mim.jsx("td", { class: "col-md-6" }))));
    }
    onCreate1000() {
        this.rows = buildRows(1000);
        this.selectedRow = undefined;
    }
    onAppend1000() {
        let newRows = buildRows(1000);
        this.rows = this.rows ? this.rows.concat(newRows) : newRows;
    }
    onUpdateEvery10th() {
        if (!this.rows)
            return;
        let row;
        for (let i = 0; i < this.rows.length; i += 10) {
            row = this.rows[i];
            row.labelTrigger.set(row.label += " !!!");
        }
    }
    onCreate10000() {
        this.rows = buildRows(10000);
        this.selectedRow = undefined;
    }
    onClear() {
        this.rows = null;
        this.selectedRow = undefined;
    }
    onSwapRows() {
        if (this.rows && this.rows.length > 998) {
            let row1 = this.rows[1];
            let row998 = this.rows[998];
            let id1 = row1.id;
            let label1 = row1.label;
            row1.idTrigger.set(row1.id = row998.id);
            row1.labelTrigger.set(row1.label = row998.label);
            row998.idTrigger.set(row998.id = id1);
            row998.labelTrigger.set(row998.label = label1);
        }
    }
}
__decorate([
    mim.trigger(0)
], Main.prototype, "rows", void 0);
__decorate([
    mim.ref
], Main.prototype, "vnTBody", void 0);
mim.mount(mim.jsx(Main, null), document.getElementById('main'));


/***/ }),

/***/ "mimbl":
/*!**************************************************************************************!*\
  !*** external {"root":"mimbl","commonjs2":"mimbl","commonjs":"mimbl","amd":"mimbl"} ***!
  \**************************************************************************************/
/***/ ((module) => {

module.exports = __WEBPACK_EXTERNAL_MODULE_mimbl__;

/***/ })

/******/ 	});
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		if(__webpack_module_cache__[moduleId]) {
/******/ 			return __webpack_module_cache__[moduleId].exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			// no module.id needed
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/************************************************************************/
/******/ 	// module exports must be returned from runtime so entry inlining is disabled
/******/ 	// startup
/******/ 	// Load entry module and return exports
/******/ 	return __webpack_require__("./src/Main.tsx");
/******/ })()
;
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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