(function webpackUniversalModuleDefinition(root, factory) {
	if(typeof exports === 'object' && typeof module === 'object')
		module.exports = factory(require("mimbl"));
	else if(typeof define === 'function' && define.amd)
		define(["mimbl"], factory);
	else {
		var a = typeof exports === 'object' ? factory(require("mimbl")) : factory(root["mimbl"]);
		for(var i in a) (typeof exports === 'object' ? exports : root)[i] = a[i];
	}
})(this, function(__WEBPACK_EXTERNAL_MODULE_mimbl__) {
return /******/ (() => { // webpackBootstrap
/******/ 	"use strict";
/******/ 	var __webpack_modules__ = ({

/***/ "./src/Main.tsx":
/*!**********************!*\
  !*** ./src/Main.tsx ***!
  \**********************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
const mim = __webpack_require__(/*! mimbl */ "mimbl");
let adjectives = ["pretty", "large", "big", "small", "tall", "short", "long", "handsome", "plain", "quaint", "clean", "elegant", "easy", "angry", "crazy", "helpful", "mushy", "odd", "unsightly", "adorable", "important", "inexpensive", "cheap", "expensive", "fancy"];
let colours = ["red", "yellow", "blue", "green", "pink", "brown", "purple", "brown", "white", "black", "orange"];
let nouns = ["table", "chair", "house", "bbq", "desk", "car", "pony", "cookie", "sandwich", "burger", "pizza", "mouse", "keyboard"];
let nextID = 1;
function buildRows(/*main: Main,*/ count) {
    let rows = new Array(count);
    let label;
    for (let i = 0; i < count; i++) {
        label = `${adjectives[rand(adjectives.length)]} ${colours[rand(colours.length)]} ${nouns[rand(nouns.length)]}`;
        rows[i] = {
            id: nextID++,
            label,
            labelTrigger: mim.createTrigger(label),
            selectedTrigger: mim.createTrigger()
        };
    }
    return rows;
}
function rand(max) {
    return Math.round(Math.random() * 1000) % max;
}
function Button(props, children) {
    return mim.jsx("div", { class: "col-sm-6 smallpad" },
        mim.jsx("button", Object.assign({ type: "button", class: "btn btn-primary btn-block" }, props), children));
}
class Main extends mim.Component {
    constructor() {
        super(...arguments);
        this.rows = null;
        this.selectedRow = undefined;
        this.onSelectRowClicked = (e, rowToSelect) => {
            if (rowToSelect === this.selectedRow)
                return;
            if (this.selectedRow)
                this.selectedRow.selectedTrigger.set(null);
            this.selectedRow = rowToSelect;
            rowToSelect.selectedTrigger.set("danger");
        };
        this.onDeleteRowClicked = (e, rowToDelete) => {
            if (rowToDelete === this.selectedRow)
                this.selectedRow = undefined;
            let i = this.rows.indexOf(rowToDelete);
            this.rows.splice(i, 1);
            this.vnTBody.spliceChildren(i, 1, undefined, 1 /* Sync */);
        };
    }
    render() {
        return (mim.jsx("div", { class: "container" },
            mim.jsx("div", { class: "jumbotron" },
                mim.jsx("div", { class: "row" },
                    mim.jsx("div", { class: "col-md-6" },
                        mim.jsx("h1", null, "Mimbl (keyed)")),
                    mim.jsx("div", { class: "col-md-6" },
                        mim.jsx("div", { class: "row" },
                            mim.jsx(Button, { id: "run", click: this.onCreate1000 }, "Create 1,000 rows"),
                            mim.jsx(Button, { id: "runlots", click: this.onCreate10000 }, "Create 10,000 rows"),
                            mim.jsx(Button, { id: "add", click: this.onAppend1000 }, "Append 1,000 rows"),
                            mim.jsx(Button, { id: "update", click: this.onUpdateEvery10th }, "Update every 10th row"),
                            mim.jsx(Button, { id: "clear", click: this.onClear }, "Clear"),
                            mim.jsx(Button, { id: "swaprows", click: this.onSwapRows }, "Swap Rows"))))),
            mim.jsx("table", { class: "table table-hover table-striped test-data" }, this.renderRows),
            mim.jsx("span", { class: "preloadicon glyphicon glyphicon-remove", "aria-hidden": "true" })));
    }
    renderRows() {
        var _a;
        return mim.jsx("tbody", { vnref: this.vnTBody, updateStrategy: { disableKeyedNodeRecycling: true } }, (_a = this.rows) === null || _a === void 0 ? void 0 : _a.map(row => mim.jsx("tr", { class: row.selectedTrigger, key: row },
            mim.jsx("td", { class: "col-md-1" }, row.id),
            mim.jsx("td", { class: "col-md-4" },
                mim.jsx("a", { click: [this.onSelectRowClicked, row] }, row.labelTrigger)),
            mim.jsx("td", { class: "col-md-1" },
                mim.jsx("a", { click: [this.onDeleteRowClicked, row] },
                    mim.jsx("span", { class: "glyphicon glyphicon-remove", "aria-hidden": "true" }))),
            mim.jsx("td", { class: "col-md-6" }))));
    }
    onCreate1000() {
        this.rows = buildRows(1000);
        this.selectedRow = undefined;
    }
    onAppend1000() {
        let newRows = buildRows(1000);
        this.rows = this.rows ? this.rows.concat(newRows) : newRows;
    }
    onUpdateEvery10th() {
        if (!this.rows)
            return;
        let row;
        for (let i = 0; i < this.rows.length; i += 10) {
            row = this.rows[i];
            row.labelTrigger.set(row.label += " !!!");
        }
    }
    onCreate10000() {
        this.rows = buildRows(10000);
        this.selectedRow = undefined;
    }
    onClear() {
        this.rows = null;
        this.selectedRow = undefined;
    }
    onSwapRows() {
        if (this.rows && this.rows.length > 998) {
            let t = this.rows[1];
            this.rows[1] = this.rows[998];
            this.rows[998] = t;
            this.vnTBody.swapChildren(1, 1, 998, 1);
        }
    }
}
__decorate([
    mim.trigger(0)
], Main.prototype, "rows", void 0);
__decorate([
    mim.ref
], Main.prototype, "vnTBody", void 0);
mim.mount(mim.jsx(Main, null), document.getElementById('main'));


/***/ }),

/***/ "mimbl":
/*!**************************************************************************************!*\
  !*** external {"root":"mimbl","commonjs2":"mimbl","commonjs":"mimbl","amd":"mimbl"} ***!
  \**************************************************************************************/
/***/ ((module) => {

module.exports = __WEBPACK_EXTERNAL_MODULE_mimbl__;

/***/ })

/******/ 	});
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		if(__webpack_module_cache__[moduleId]) {
/******/ 			return __webpack_module_cache__[moduleId].exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			// no module.id needed
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/************************************************************************/
/******/ 	// module exports must be returned from runtime so entry inlining is disabled
/******/ 	// startup
/******/ 	// Load entry module and return exports
/******/ 	return __webpack_require__("./src/Main.tsx");
/******/ })()
;
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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