<!--
Quick Reference Examples: 

  Linking to other sections on the page: <a name="abcd"></a> where you want to link to and refer to it on the same page by [link text](#abcd)
-->

# ISAAC Web GUI
---


The ISAAC Web Graphical User Interface is a modern and adaptive way to communicate with your system. The interface will automatically adjust itself to complement the resolution of any desktop, tablet, or mobile device. This adaptive interface ensures that operation and usability are available from any platform or device.

## Connection
---

Your ISAAC interface is configured for access via a specific URL that is unique to your system. You can find this URL by referring to the Getting Started Kit that came with your ISAAC package. Once you’ve successfully connected to your ISAAC system through a web browser, you will land on the Login page. Here, you will be prompted for the email address and password associated with your ISAAC account. For the default e-mail address and password, please refer to the Getting Started Kit. During the configuration process, this default account information will be removed or changed as additional users are added to the system.

!> To insure the best user experience, we strongly recommend the use of the latest version of Google Chrome.



## Navigation
---
Navigation of the ISAAC system is accomplished through the use of the Unified Interface, which provides a centralized user experience and offers integrated control over your system. Scheduling, Playlists, User Management, Remote Access and Asset Configuration are all in one place.

### Home (Landing Page)
---


After you’ve logged in, you will be greeted by the Home page where you will find access to the [Menu Bar](isaac-gui?id=menu-bar), [User Pane](isaac-gui?id=user-pane-1), [Navigation Sidebar](isaac-gui?id=navigation-sidebar), and your [Home page](isaac-gui?id=home-landing-page).

### Menu Bar 
---


The Menu Bar is a convenient location for tools that will be continuously utilized by the various users you plan to add to your ISAAC system.

Going from left to right, you will find the ISAAC Home button, then the Navigation Collapse button. To the right of the Navigation Collapse button is the name you've given to your ISAAC system. Learn more about how the name can be configured in the [System Settings](settings?id=system-settings section). 

Looking toward the right side of the Menu Bar will allow you to see the clock, next to which is the full-screen button, the Information Center icon, the Notification icon, and the User Pane icon.

#### ISAAC Home


As mentioned before, the ISAAC Home button on the far left functions as a convenient way to get back to the [Home page](isaac-gui?id=home-landing-page) of the interface. No matter which page or section you might be currently viewing, one click of the ISAAC Home button will bring you back to the [Home page](isaac-gui?id=home-landing-page).

#### Navigation Collapse


The Navigation Collapse button is what allows you to choose the way your [Navigation Sidebar](isaac-gui?id=navigation-sidebar) is displayed. By default the [Navigation Sidebar](isaac-gui?id=navigation-sidebar) contains all of the interface's section names, the full ISAAC name in the Home button, and all of the logos associated with these names. Clicking on the Navigation Collapse button reformats the [Navigation Sidebar](isaac-gui?id=navigation-sidebar) so that it minimizes to only contain the logos for each section. This in-turn frees up the room on the interface that was used by the width of the words in the sidebar.

#### ISAAC System Name


As mentioned above, you can give your ISAAC system its own unique name so that it truly becomes yours. Information on how to do this is covered in the [System Settings](settings?id=system-settings) section.

#### Clock


The Clock gives you a convenient way to quickly know what time it is from any section of your ISAAC interface. This will no doubt help with any countdowns, estimations, or general inquiries you will have to answer based on time. 

?> You can change the time zone in the [System Settings](settings) section.

#### Full Screen


The Full Screen button to the right of the Clock allows the ISAAC interface to occupy all of the real estate on the screen rather than being contained within your web browser's window. If you are ever in Full Screen, click on the Full Screen icon to return back to window mode.

#### Info Center


The Info Center is where you can find all of the information available for the ISAAC system. This knowledge base is continuously expanding to incorporate new ideas and features that will allow your ISAAC system to become an even more essential part of your day to day operations.

?> As of this release, the Info Center is how users can access the Documentation and the Change Log.

#### Notification Preview


Clicking on the Notification Preview icon will display a drop-down list of the most recent [Alerts](alerts-notifications) that your system has been configured to make you aware of. From this drop-down menu you may choose to view all of your notifications, which will open the Notifications Center in the User Pane. For more information about the Notification Center click [here](alerts-notifications?id=notifications). Also, to learn more about Alerts and Notifications, click [here](alerts-notifications).

#### User Pane


The User Pane is where you can truly make ISAAC your own. You can change your Avatar by clicking on the Avatar icon, change your password, choose a UI theme color, or adjust the layout of your ISAAC interface.

?> Clicking on the Avatar icon will take you to the My Profile section which allows you to drag an drop an image to update your Avatar. For more information, please refer to the [My Profile](settings?id=my-profile) section.

### User Pane
---




#### UI Settings
The User Interface Settings section gives you options to make your ISAAC interface more customizable. In the top of the tab you have the option to change your password, or log out of your current session in the ISAAC interface. Below this, you have the option to choose one of eight color themes for your ISAAC interface. To change to any of the available color themes for your profile, simply click on a theme color.

?> Each user has the option to have a color theme independently associated with their account.

Below the themes are selection sliders. The Layout sliders, Fixed and Boxed, allow you to adjust the layout of your ISAAC interface. If activated (the white circle on the slider will be to the right with a blue background), the Fixed slider will keep both the [Menu Bar](isaac-gui?id=menu-bar) and [Navigation Sidebar](isaac-gui?id=navigation-sidebar) in place as you scroll. If de-activated (the white circle on the slider will be to the left with a white background), both the [Menu Bar](isaac-gui?id=menu-bar) and [Navigation Sidebar](isaac-gui?id=navigation-sidebar) will scroll up and down with the rest of the page. If the Boxed slider is activated, the interface will become contained inside a box that sits in the middle of your web browser's window. If this slider is not activated, the interface will occupy the entire width of the window.

The Aside sliders, Hover and Show Scrollbar, allow you to determine how menu items on the [Navigation Sidebar](isaac-gui?id=navigation-sidebar) appear. If the Hover slider is activated, sub-menu items of the [Navigation Sidebar](isaac-gui?id=navigation-sidebar) will appear on the right side of the [Navigation Sidebar](isaac-gui?id=navigation-sidebar). When this slider is de-activated, sub-menu items appear underneath their respective section. When the Show Scrollbar slider is activated, you are able to scroll through sub-menu items that could potentially extend through the bottom of your window (such as a long list of Control Panels). If this slider is de-activated, you will need to scroll down to view all of the sub-menu items. 


#### Notification Center
The Notification Center is where you have the ability to view all of the details related to the [Alerts and Notifications](alerts-notifications) that have been sent to you from ISAAC. For more information on Alerts and Notifications, please visit the [Alerts and Notifications](alerts-notifications) section.

### Navigation Sidebar
---


The Navigation Sidebar is what provides you the access to the main sections of the ISAAC interface.

#### Home (Landing Page)


The [Home](isaac-gui?id=home-landing-page) page is the landing page for all users who log into the ISAAC system, which is where you can find shortcuts to the [Logging](logging), [Schedule](schedule), and [User Management](security?id=users) sections.

#### Logging


The [Logging](logging) section is where you can locate all of the logs that have been generated and reported to ISAAC. Learn more in the [Logging](logging) section.

#### Control Panels


Any [Control Panels](control-panels) available over the web can be accessed within the ISAAC Control Panels section. Learn more in the [Control Panels](control-panels) section.

#### Schedule


For any of the schedule elements that you would like your system to perform in the future, you can utilize the ISAAC [Schedule](schedule) to place these elements onto a calendar. There are several different tools for building schedule elements that a system can perform. Learn more in the [Schedule](schedule) section.

#### Security


The [Security](security) section is where you will find the ability to edit user information, as well as the roles that you allow users of your ISAAC system to have. Learn more in the [Security](security) section.

#### Settings


The drop down for the Settings tab allows you to configure either the System Settings, your Personal Account Settings, or the Module Editor Settings. Learn more in the [Settings](settings) section.