# ISAAC® Documentation

---

![picture 209](_images/Picture209.png  ":ignore")

## Introduction

ISAAC (Integrated Scheduler and Automation Control) is the first fully integrated AV/IT platform of its kind that empowers users to have centralized scheduling, user and log management; and access to a myriad of devices, operating systems under a single piece of hardware. It offers all the tools for IT administrators, system integrators, and operators for complete success in their function within the AV/IT ecosystem.

?> Within this documentation, you will be able to find all the terminology, tutorials, FAQs, and all the information you need to be able to confidently use the ISAAC system.

## Virtualization

---

In order to fully understand the capabilities that ISAAC is able to offer an organization and their users, one must have a solid grasp of virtualization technology to unlock all the benefits. If you are already familiar with virtualization technology, feel free to skip to the next section or do a quick refresher to solidify concepts.

?> Virtualization is the process of creating a software-based representation of something rather than a physical one. This can apply to operating systems, applications, servers, storage, and networks.  

Virtualization uses software to simulate the existence of hardware and create a virtual computer system. Doing this allows businesses to run more than one virtual computer system – and multiple operating systems and applications – on a single server. This can provide economies of scale and greater efficiency. The whole idea behind using virtualization is to have a more efficient environment that’s easier to manage and orchestrate. With fewer machines to buy, configure, install, maintain, troubleshoot and support, IT can help the business run leaner and more profitably.

### Virtual Machines

---

A virtual computer system is known as a “virtual machine” (VM): an isolated software container with an operating system and application inside. Each self-contained VM is completely independent. Putting multiple VMs on a single computer enables several operating systems and applications to run on just one physical server, or “host”. 

---

### Hypervisor

A thin layer of software called a hypervisor decouples the virtual machines from the host and dynamically allocates computing resources to each virtual machine as needed. It is installed on the host computer and provides the virtual hardware and physical resources on which you create VMs. The host and the resources it controls then become part of a larger pool of resources that can be shared by VMs on the network. The hypervisor controls how those resources are accessed by the VMs. It abstracts x86 server resources and brings them together into logical pools. Brings speed and agility with virtual symmetric multiprocessing, dynamic allocation of shared storage and live migration of VMs and VM disks with no disruption. Provides strong security with high availability, fault tolerance, VM backup and recovery. There are multiple types of hypervisors:

##### Bare metal hypervisors

These are commonly called Type 1 hypervisors, and run directly on a physical host server. Type 1 hypervisors directly control the server hardware and manage guest operating systems. They partition the server into multiple VMs that operate independently but share the same network resources.

##### Hosted hypervisors

These are commonly called Type 2 hypervisors, and are installed as virtual workstations on top of a server’s existing operating system, such as Windows Server, Linux or a custom operating system. The host operating system has direct access to network resources and hardware, and manages operating system connections to those resources. The hosted hypervisor coordinates calls between the VM and the resources it needs to access, including CPU, memory, storage, and the network.

---

### Benefits of Virtualization

 
##### Partitioning  

* Run multiple operating systems on one physical machine.

* Divide system resources between virtual machines.

* Provide fault and security isolation at the hardware level.

* Preserve performance with advanced resource controls.

* Save the entire state of a virtual machine to files.

* Move and copy virtual machines as easily as moving and copying files.

* Provision or migrate any virtual machine to any physical server.


#####  Reduce IT Costs and Increase Control

* Reduce server costs with server virtualization and consolidation.

*  Reduce power and cooling costs by cutting down on the amount of idle storage devices in the array. 

* Reduce the time it takes to provision new servers.

* Centralize server management and automate your data center with vCenter Server.

* Reduction in CapEx and an increase in Capacity Utilization.

* Automate IT – configure, provision, deploy, and update infrastructure and apps.


##### Fewer business disruptions 

* Failed servers are bypassed and data keeps flowing.

* Easy to have full backups or snapshots of your virtual servers, virtual machines, databases, files and settings. Virtual environments can be backed up from the system level to the object level as often as you want, and it’s all transparent.

* Full data protection for all workloads for fast recovery from data disasters.

* Secure Application Infrastructure, Secure Identity and Endpoints, Streamline Compliance.

* Analyzes and remediates issues quickly. Automated load balancing.

---

### Why is Virtualization needed?

Stuff happens. Power grids go down, storms hit, viruses spread. The threats never stop. Audiovisual systems are expected to operate 24x7, be fully secure, protect sensitive data and meet every compliance
requirement. After a disaster passes and there’s still an inch of water in the equipment room, workers expect to
be back online with no interruption, with every workload, app, file and setting right where they left it.
That’s the expectation of the modern Audiovisual work environment. Zero service disruption when disaster strikes. Guaranteed resource availability across the business, so outages are avoided. When a virtual environment is firing on all cylinders, it drives down costs and reduces unplanned downtime.

---

## Platform

There are three defined ISAAC® Products offering multiple solutions depending on the size of the project and solution needed. The following products are currently defined:

---

### Prelude

Prelude is a stand alone server offering an entry point into virtualization technology. It comes as a compact 1U server for small installations, or in an extra-deep 2U chassis for more demanding systems. Although Prelude hardware has self-redundancy capabilities such as redundant power supplies and RAID configured storage, it does not provide the level of resiliency you can expect from the rest of the product line.

---

### Foundation

Foundation is meant to maximize uptime with its dual-server configuration. It includes virtual-storage technology that provides High Availability (HA). In case of hardware failure on one server, the affected hosted application can be automatically restarted on the remaining server.  With the FT (Fault Tolerance) option, some specific applications do not even need to be rebooted. FT provides seamless failover with zero downtime. No human intervention needed. Foundation is available in compact 1U or extra-deep 2U form factor.

---

### Nemesis

Nemesis is a clustered solution, based on 2 (or more) servers, plus an independent shared storage unit (SAN). Nemesis is highly scalable and offers both HA and FT throughout. This is important for time-critical installations like live events, entertainment with a captive audience, and high profile locations. Nemesis can be sized in numerous ways, for a simple museum exhibit to an entire large scale theme park.

--- 

## Modular Architecture

Beyond the virtualization software and built-in features that ISAAC offers lies a complete modular architecture underneath that provides interoperability, scalability, and customization to each owner of an ISAAC system. Each application has its own challenges and needs and with ISAAC's modular architecture, the system has the flexibility in its design to add additional Subsystem and Expansion Modules. As the scale and scope increases with each project, achieving your business and technical goals can be as easy as finding the right Subsystem or Expansion Module. For a complete list of the available Modules for ISAAC, please refer to the [Modules](modules) section.

---

## Hosting Capabilities

What requirements does something need to have to be able to be run inside ISAAC?

* Be fundamentally software based.
* Be able to be located on the client premises. 
* Be able to run on x86/x64 hardware.
* Run inside Linux or Windows environments.
* All communication to endpoint devices must happen through the data network as it leaves the server. Once the data has left the server, other physical devices can be used to translate protocols as needed.