/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.wrapper;

import java.io.File;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.Properties;
import org.gradle.cli.CommandLineParser;
import org.gradle.cli.ParsedCommandLine;
import org.gradle.cli.SystemPropertiesCommandLineConverter;
import org.gradle.wrapper.BootstrapMainStarter;
import org.gradle.wrapper.Download;
import org.gradle.wrapper.Install;
import org.gradle.wrapper.PathAssembler;
import org.gradle.wrapper.SystemPropertiesHandler;
import org.gradle.wrapper.WrapperExecutor;

public class GradleWrapperMain {
    public static final String DEFAULT_GRADLE_USER_HOME = System.getProperty("user.home") + "/.gradle";
    public static final String GRADLE_USER_HOME_OPTION = "g";
    public static final String GRADLE_USER_HOME_DETAILED_OPTION = "gradle-user-home";
    public static final String GRADLE_USER_HOME_PROPERTY_KEY = "gradle.user.home";
    public static final String GRADLE_USER_HOME_ENV_KEY = "GRADLE_USER_HOME";

    public static void main(String[] args) throws Exception {
        File wrapperJar = GradleWrapperMain.wrapperJar();
        File propertiesFile = GradleWrapperMain.wrapperProperties(wrapperJar);
        File rootDir = GradleWrapperMain.rootDir(wrapperJar);
        CommandLineParser parser = new CommandLineParser();
        parser.allowUnknownOptions();
        parser.option(GRADLE_USER_HOME_OPTION, GRADLE_USER_HOME_DETAILED_OPTION).hasArgument();
        SystemPropertiesCommandLineConverter converter = new SystemPropertiesCommandLineConverter();
        converter.configure(parser);
        ParsedCommandLine options = parser.parse(args);
        Properties systemProperties = System.getProperties();
        systemProperties.putAll((Map<?, ?>)((Map)converter.convert(options)));
        File gradleUserHome = GradleWrapperMain.gradleUserHome(options);
        GradleWrapperMain.addSystemProperties(gradleUserHome, rootDir);
        WrapperExecutor wrapperExecutor = WrapperExecutor.forWrapperPropertiesFile(propertiesFile, System.out);
        wrapperExecutor.execute(args, new Install(new Download("gradlew", GradleWrapperMain.wrapperVersion()), new PathAssembler(gradleUserHome)), new BootstrapMainStarter());
    }

    private static void addSystemProperties(File gradleHome, File rootDir) {
        System.getProperties().putAll(SystemPropertiesHandler.getSystemProperties(new File(gradleHome, "gradle.properties")));
        System.getProperties().putAll(SystemPropertiesHandler.getSystemProperties(new File(rootDir, "gradle.properties")));
    }

    private static File rootDir(File wrapperJar) {
        return wrapperJar.getParentFile().getParentFile().getParentFile();
    }

    private static File wrapperProperties(File wrapperJar) {
        return new File(wrapperJar.getParent(), wrapperJar.getName().replaceFirst("\\.jar$", ".properties"));
    }

    private static File wrapperJar() {
        URI location;
        try {
            location = GradleWrapperMain.class.getProtectionDomain().getCodeSource().getLocation().toURI();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        if (!location.getScheme().equals("file")) {
            throw new RuntimeException(String.format("Cannot determine classpath for wrapper Jar from codebase '%s'.", location));
        }
        return new File(location.getPath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String wrapperVersion() {
        String string;
        InputStream resourceAsStream = GradleWrapperMain.class.getResourceAsStream("/build-receipt.properties");
        if (resourceAsStream == null) {
            throw new RuntimeException("No build receipt resource found.");
        }
        Properties buildReceipt = new Properties();
        try {
            buildReceipt.load(resourceAsStream);
            String versionNumber = buildReceipt.getProperty("versionNumber");
            if (versionNumber == null) {
                throw new RuntimeException("No version number specified in build receipt resource.");
            }
            string = versionNumber;
        }
        catch (Throwable throwable) {
            try {
                resourceAsStream.close();
                throw throwable;
            }
            catch (Exception e) {
                throw new RuntimeException("Could not determine wrapper version.", e);
            }
        }
        resourceAsStream.close();
        return string;
    }

    private static File gradleUserHome(ParsedCommandLine options) {
        String gradleUserHome = null;
        if (options.hasOption(GRADLE_USER_HOME_OPTION)) {
            gradleUserHome = options.option(GRADLE_USER_HOME_OPTION).getValue();
        }
        if (gradleUserHome != null) {
            return new File(gradleUserHome);
        }
        gradleUserHome = System.getProperty(GRADLE_USER_HOME_PROPERTY_KEY);
        if (gradleUserHome != null) {
            return new File(gradleUserHome);
        }
        gradleUserHome = System.getenv(GRADLE_USER_HOME_ENV_KEY);
        if (gradleUserHome != null) {
            return new File(gradleUserHome);
        }
        return new File(DEFAULT_GRADLE_USER_HOME);
    }
}

